unit ConnectForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TConnectForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    lblIPAddress: System.Windows.Forms.Label;
    tbAddress: System.Windows.Forms.TextBox;
    btnCancel: System.Windows.Forms.Button;
    btnOK: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TConnectForm_Load(sender: System.Object; e: System.EventArgs);
    procedure btnOK_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  strict private
    FAddress: string;
    procedure PopulateControls;
  public
    constructor Create;
    class function ShowConnectForm(var pAddress: string): DialogResult;
  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TConnectForm.InitializeComponent;
begin
  Self.lblIPAddress := System.Windows.Forms.Label.Create;
  Self.tbAddress := System.Windows.Forms.TextBox.Create;
  Self.btnCancel := System.Windows.Forms.Button.Create;
  Self.btnOK := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // lblIPAddress
  // 
  Self.lblIPAddress.Location := System.Drawing.Point.Create(8, 10);
  Self.lblIPAddress.Name := 'lblIPAddress';
  Self.lblIPAddress.Size := System.Drawing.Size.Create(48, 16);
  Self.lblIPAddress.TabIndex := 0;
  Self.lblIPAddress.Text := 'Address';
  // 
  // tbAddress
  // 
  Self.tbAddress.Location := System.Drawing.Point.Create(64, 8);
  Self.tbAddress.Name := 'tbAddress';
  Self.tbAddress.Size := System.Drawing.Size.Create(152, 20);
  Self.tbAddress.TabIndex := 1;
  Self.tbAddress.Text := '';
  // 
  // btnCancel
  // 
  Self.btnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.btnCancel.Location := System.Drawing.Point.Create(124, 40);
  Self.btnCancel.Name := 'btnCancel';
  Self.btnCancel.TabIndex := 3;
  Self.btnCancel.Text := 'Cancel';
  // 
  // btnOK
  // 
  Self.btnOK.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.btnOK.Location := System.Drawing.Point.Create(28, 40);
  Self.btnOK.Name := 'btnOK';
  Self.btnOK.TabIndex := 2;
  Self.btnOK.Text := 'OK';
  Include(Self.btnOK.Click, Self.btnOK_Click);
  // 
  // TConnectForm
  // 
  Self.AcceptButton := Self.btnOK;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.btnCancel;
  Self.ClientSize := System.Drawing.Size.Create(226, 76);
  Self.Controls.Add(Self.btnOK);
  Self.Controls.Add(Self.btnCancel);
  Self.Controls.Add(Self.tbAddress);
  Self.Controls.Add(Self.lblIPAddress);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TConnectForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Connect To...';
  Include(Self.Load, Self.TConnectForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TConnectForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TConnectForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

class function TConnectForm.ShowConnectForm(var pAddress: string): DialogResult;
var
  lConnectForm: TConnectForm;
begin
  lConnectForm := TConnectForm.Create;
  lConnectForm.FAddress := pAddress;
  Result := lConnectForm.ShowDialog;
  pAddress := lConnectForm.FAddress;
end;

procedure TConnectForm.btnOK_Click(sender: System.Object; e: System.EventArgs);
begin
  FAddress := tbAddress.Text;
end;

procedure TConnectForm.TConnectForm_Load(sender: System.Object; e: System.EventArgs);
begin
  PopulateControls;
end;

procedure TConnectForm.PopulateControls;
begin
  tbAddress.Text := FAddress;
end;

end.
